{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnCodeDemo;
{* |<PRE>
================================================================================
* ƣCnPack
* Ԫƣ淶ʾԪ
* Ԫߣܾ (zjy@cnpack.org)
* ƽ̨PWin98SE + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6
*   õԪеַϱػʽ
* Ԫʶ$Id: DelphiԪ淶ʽ.pas,v 1.8 2009/02/25 12:32:57 liuxiao Exp $
*     ע- ˵ԪֻΪ CnPack Ĵ淶ʾԪĶԱã
*             ʵʵıԡ
*           - еTCnTimerõ߳̽жʱƣȱTTimerҪߣӦ
*             Ҳռý϶CPUԴ
* ޸ļ¼2009.02.18 V1.1
*               ĵԪ˵
*           2002.04.18 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Windows, Classes, SysUtils, ExtCtrls, CnClasses, CnConsts, CnCompConsts;

type

//==============================================================================
// ߾ȶʱʱ߳
//==============================================================================

{ TCnTimerThread }

  TCnTimer = class;

  TCnTimerThread = class(TThread)
  private
    FOwner: TCnTimer;
    FInterval: Word;
    FStop: THandle;
  protected
    constructor Create(CreateSuspended: Boolean); virtual;
    procedure Execute; override;
  end;

//==============================================================================
// ߾ȶʱ
//==============================================================================

{ TCnTimer }

  TTimerQuality = (tqHighest, tqHigh, tqLow);
  {* ߾ȶʱʱ
   |<PRE>
     tqHighest  - ߾ȣøȼ̶߳ʱ
     tqHigh     - ߾ȣͨȼ̶߳ʱ
     tqLow      - ;ȣڲʹTTimerжʱ
   |</PRE>}

  TCnTimer = class(TCnComponent)
  {* ߾ȶʱʹõ߳̽жʱƣʹ÷TTimerһ
     һQualityԿƶʱ}
  private
    FOnTimer: TNotifyEvent;
    FQuality: TTimerQuality;
    FEnabled: Boolean;
    FInterval: Word;
    FTimerThread: TCnTimerThread;
    FTimer: TTimer;
    FLastTick: Cardinal;
    FLastCountTick: Cardinal;
    FActualInterval: Integer;
    FActualRate: Integer;
    FCount: Integer;
    procedure DoTimer;
    procedure OnTimerTimer(Sender: TObject);
    procedure CreateTimer;
    procedure CreateTimerThread;
    procedure FreeTimer;
    procedure FreeTimerThread;
    procedure SetEnabled(Value: Boolean);
    procedure SetInterval(Value: Word);
    procedure SetQuality(const Value: TTimerQuality);
  protected
    function GetAuthor: string; override;
    function GetComment: string; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property ActualInterval: Integer read FActualInterval;
    {* ʵʵĶʱλΪ}
    property ActualRate: Integer read FActualRate;
    {* ʵʵĶʱٶȣλΪÿ}
  published
    property Enabled: Boolean read FEnabled write SetEnabled;
    {* Ƿʱ¼}
    property Interval: Word read FInterval write SetInterval default 1000;
    {* ʱλΪ}
    property Quality: TTimerQuality read FQuality write SetQuality default tqLow;
    {* ʱȣIntervalС55Win9X10WinNTΪ߾}
    property OnTimer: TNotifyEvent read FOnTimer write FOnTimer;
    {* ʱ¼}
  end;

implementation

//==============================================================================
// ߾ȶʱʱ߳
//==============================================================================

{ TCnTimerThread }

// ʼ߳
constructor TCnTimerThread.Create(CreateSuspended: Boolean);
begin
  inherited Create(CreateSuspended);
  FStop := CreateEvent(nil, False, False, nil); // ˳¼
end;

// ߳
procedure TCnTimerThread.Execute;
begin
  repeat                      // ȴ˳¼λ FInterval ʱ˳
    if WaitForSingleObject(FStop, FInterval) = WAIT_TIMEOUT then
      Synchronize(FOwner.DoTimer); // ͬʽʱ¼
  until Terminated;
  CloseHandle(FStop);         // ͷ¼
end;

{ TCnTimer }

//==============================================================================
// ߾ȶʱ
//==============================================================================

// ʼ
constructor TCnTimer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEnabled := False;
  FInterval := 1000;
  FQuality := tqLow;
  FTimer := nil;
  FTimerThread := nil;
  CreateTimer;
end;

// ͷ
destructor TCnTimer.Destroy;
begin
  FreeTimer;
  FreeTimerThread;
  inherited Destroy;
end;

//------------------------------------------------------------------------------
// ¼
//------------------------------------------------------------------------------

// ʱ¼
procedure TCnTimer.DoTimer;
var
  Tick: Cardinal;
begin
  Tick := GetTickCount;
  if (FLastTick = 0) and (FLastCountTick = 0) then
  begin
    FLastTick := Tick;
    FLastCountTick := Tick;
  end
  else
  begin
    FActualInterval := Tick - FLastTick;
    FLastTick := Tick;
    if Tick - FLastCountTick >= 1000 then
    begin
      FActualRate := FCount;
      FLastCountTick := Tick;
      FCount := 0;
    end else
      Inc(FCount);
  end;
  begin
    if Assigned(FOnTimer) then
      FOnTimer(Self);
  end;
end;

//------------------------------------------------------------------------------
// ڲʱͷ
//------------------------------------------------------------------------------

// ڲTimer¼
procedure TCnTimer.OnTimerTimer(Sender: TObject);
begin
  DoTimer;
end;

// ڲTimerʱ;ȣ
procedure TCnTimer.CreateTimer;
begin
  if not Assigned(FTimer) then
  begin
    FTimer := TTimer.Create(Self);
    FTimer.OnTimer := OnTimerTimer;
    FTimer.Interval := FInterval;
    FTimer.Enabled := FEnabled;
  end;
end;

// ʱ̣߳߾ȣ
procedure TCnTimer.CreateTimerThread;
begin
  if not Assigned(FTimerThread) then
  begin
    FTimerThread := TCnTimerThread.Create(True);
    FTimerThread.FOwner := Self;
    FTimerThread.FreeOnTerminate := False;
    FTimerThread.Priority := tpNormal;
    FTimerThread.FInterval := FInterval;
    if FEnabled then
    begin
      if FInterval > 0 then
      begin
        SetEvent(FTimerThread.FStop);
        FTimerThread.Resume;
      end;
    end
    else
      FTimerThread.Suspend;
  end;
end;

// ͷڲʱ;ȣ
procedure TCnTimer.FreeTimer;
begin
  if Assigned(FTimer) then
  begin
    FTimer.Free;
    FTimer := nil;
  end;
end;

// ͷŶʱ̣߳߾ȣ
procedure TCnTimer.FreeTimerThread;
begin
  if Assigned(FTimerThread) then
  begin
    FTimerThread.Terminate;
    SetEvent(FTimerThread.FStop);
    if FTimerThread.Suspended then FTimerThread.Resume;
    FTimerThread.WaitFor;
    FTimerThread.Free;
    FTimerThread := nil;
  end;
end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

// öʱ
procedure TCnTimer.SetQuality(const Value: TTimerQuality);
begin
  if FQuality <> Value then
  begin
    FQuality := Value;
    case FQuality of
      tqHighest, tqHigh:
        begin
          FreeTimer;
          CreateTimerThread;
          if Value = tqHighest then
            FTimerThread.Priority := tpHigher
          else
            FTimerThread.Priority := tpNormal;
        end;
      tqLow:
        begin
          FreeTimerThread;
          CreateTimer;
        end;
    end;
  end;
end;

// Ƿʱ
procedure TCnTimer.SetEnabled(Value: Boolean);
begin
  if Value <> FEnabled then
  begin
    FEnabled := Value;
    if FQuality = tqLow then
      FTimer.Enabled := FEnabled
    else
    begin
      if FEnabled then
      begin
        if FTimerThread.FInterval > 0 then
        begin
          SetEvent(FTimerThread.FStop);
          FTimerThread.Resume;
        end;
      end
      else
        FTimerThread.Suspend;
    end;
  end;
end;

// öʱ
procedure TCnTimer.SetInterval(Value: Word);
begin
  if Value <> FInterval then
  begin
    FInterval := Value;
    Enabled := False;
    if FQuality = tqLow then
      FTimer.Interval := FInterval
    else
      FTimerThread.FInterval := FInterval;
    Enabled := True;
  end;
end;

// ȡ
function TCnTimer.GetAuthor: string;
begin
  Result := SCnPack_Zjy;
end;

// ȡע
function TCnTimer.GetComment: string;
begin
  Result := SCnTimerComment;
end;

end.

