{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnSourceDiffWizard;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣԴȽרҵԪ
* Ԫߣܾ (zjy@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   ôеַϱػʽ
* Ԫʶ$Id: CnSourceDiffWizard.pas 1385 2013-12-31 15:39:02Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2003.03.11 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNSOURCEDIFFWIZARD}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ToolsAPI, IniFiles, CnWizClasses, CnWizUtils, CnWizConsts, CnConsts,
  CnSourceDiffFrm;

type

//==============================================================================
// ԴȽר
//==============================================================================

{ TCnSourceDiffWizard }

  TCnSourceDiffWizard = class(TCnMenuWizard)
  private
    FIni: TCustomIniFile;
  protected
    procedure SetActive(Value: Boolean); override;
  public
    constructor Create; override;
    destructor Destroy; override;
    class procedure GetWizardInfo(var Name, Author, Email, Comment: string); override;
    function GetCaption: string; override;
    function GetHint: string; override;
    function GetDefShortCut: TShortCut; override;
    procedure Execute; override;
  end;

{$ENDIF CNWIZARDS_CNSOURCEDIFFWIZARD}

implementation

{$IFDEF CNWIZARDS_CNSOURCEDIFFWIZARD}

//==============================================================================
// ԴȽר
//==============================================================================

{ TCnSourceDiffWizard }

constructor TCnSourceDiffWizard.Create;
begin
  inherited;
  FIni := CreateIniFile;
end;

destructor TCnSourceDiffWizard.Destroy;
begin
  FreeSourceDiffForm;
  FIni.Free;
  inherited;
end;

procedure TCnSourceDiffWizard.Execute;
begin
  ShowSourceDiffForm(FIni, Self.Icon);
end;

function TCnSourceDiffWizard.GetCaption: string;
begin
  Result := SCnSourceDiffWizardMenuCaption;
end;

function TCnSourceDiffWizard.GetDefShortCut: TShortCut;
begin
  Result := 0;
end;

function TCnSourceDiffWizard.GetHint: string;
begin
  Result := SCnSourceDiffWizardMenuHint;
end;

class procedure TCnSourceDiffWizard.GetWizardInfo(var Name, Author, Email, Comment: string);
begin
  Name := SCnSourceDiffWizardName;
  Author := 'Angus Johnson' + ';' + SCnPack_Zjy;
  Email := 'ajohnson@rpi.net.au' + ';' + SCnPack_ZjyEmail;
  Comment := SCnSourceDiffWizardComment;
end;

procedure TCnSourceDiffWizard.SetActive(Value: Boolean);
begin
  inherited;
  if not Active then
  begin
    if CnSourceDiffForm <> nil then
      FreeAndNil(CnSourceDiffForm);
  end;
end;

initialization
  RegisterCnWizard(TCnSourceDiffWizard); // ער

{$ENDIF CNWIZARDS_CNSOURCEDIFFWIZARD}
end.
