{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnASHostServices;
{* |<PRE>
================================================================================
* ƣӹ
* ԪƣActiveScript Host Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪ˹ ActiveScript ʹõ Host 
* ƽ̨PWin2K SP3 + Delphi 7
* ݲԣPWin9X/2000/XP + Delphi 6/7 C++Builder 6
*   õԪеַϱػʽ
* Ԫʶ$Id: CnASHostServices.pas 1385 2013-12-31 15:39:02Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2003.10.31
*                Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

{$IFNDEF COMPILER6_UP}
  'Error: This unit can used only for Delphi / C++Builder 6 or up.'
{$ENDIF COMPILER6_UP}

uses
  Windows, SysUtils, Classes, TypInfo, ComObj, CnASIDispatchProxy, CnCommon;

type
  
//==============================================================================
// ActiveScript 
//==============================================================================

{ ICnASService }

  ICnASService = interface(IActiveScriptInvokable)
  ['{5640170F-9C03-400E-9E46-549A80F3ABDD}']
  end;

{ TCnASService }

  TCnASService = class(TInterfacedObject, IActiveScriptInvokable, ICnASService)
  {* ActiveScript ࣬ṩűʹã
     űɵ HostServices.CreateObject('ServiceName', CreateParam) ʹá}
  public
    constructor Create(const CreateParam: OleVariant); virtual;
    {* ๹CreateParam ΪűĲ}
  end;

  TCnASServiceClass = class of TCnASService;

//==============================================================================
// ActiveScript Host 
//==============================================================================

{ ICnASHostServices }

  ICnASHostServices = interface(IActiveScriptInvokable)
  ['{E5B6A915-69AE-4CB2-BFBE-9411B75F8E49}']
    // 
    function CreateObject(const ServiceName: string; CreateParam: OleVariant): IUnknown; stdcall;
    {* 첢һָʶƵĶӿڣServiceName Ϊƣ
       CreateParam ΪصĲ}

    // Ի
    function MessageBox(const Text, Caption: string; Flags: Integer): Integer; stdcall;
    {* ϢԻ}
    procedure InfoDlg(const Text: string; const Caption: string = ''); stdcall;
    {* ʾʾ}
    function InfoOk(Text: string; Caption: string = ''): Boolean; stdcall;
    {* ʾʾȷϴ}
    procedure ErrorDlg(Text: string; Caption: string = ''); stdcall;
    {* ʾ󴰿}
    procedure WarningDlg(Text: string; Caption: string = ''); stdcall;
    {* ʾ洰}
    function QueryDlg(Text: string; DefaultNo: Boolean = False;
      Caption: string = ''): Boolean; stdcall;
    {* ʾѯʶԻ}
    function InputQuery(const Caption, Prompt: string): string; stdcall;
    {* ʾһ봰ڣȡؿַ}

    { TODO :  Host ܡ }
  end;

function GetCnASHostServices: IDispatch;
{* һ֧ ICnASHostServices  IDispatch Ľӿڡ
   ɹ ActiveScriptSite.AddNamedItem ʹá}

//==============================================================================
// Host бع
//==============================================================================

procedure RegisterCnASService(const ServiceName: string;
  const AClass: TCnASServiceClass; IntfTypeInfo: PTypeInfo);
{* עһ TCnASService ãÿʵӦڸõԪ initialization
   ڵøùעط }

implementation

//==============================================================================
// Host бع
//==============================================================================

var
  CnASServiceClassList: TStrings = nil; // Host б
  CnASServiceIntfTypeInfoList: TList = nil; // ʵֵĽӿϢб

// עһ TCnASServiceClass 
procedure RegisterCnASService(const ServiceName: string;
  const AClass: TCnASServiceClass; IntfTypeInfo: PTypeInfo);
begin
  if CnASServiceClassList.IndexOf(ServiceName) < 0 then
  begin
    CnASServiceClassList.AddObject(ServiceName, TObject(AClass));
    CnASServiceIntfTypeInfoList.Add(IntfTypeInfo);
  end;
end;

// ݷȡָķ
function GetCnASServiceClass(const ServiceName: string; var IntfTypeInfo:
  PTypeInfo): TCnASServiceClass;
var
  Idx: Integer;
begin
  Idx := CnASServiceClassList.IndexOf(ServiceName);
  if Idx >= 0 then
  begin
    Result := TCnASServiceClass(CnASServiceClassList.Objects[Idx]);
    IntfTypeInfo := CnASServiceIntfTypeInfoList[Idx];
  end
  else
  begin
    Result := nil;
    IntfTypeInfo := nil;
  end;
end;

//==============================================================================
// ActiveScript 
//==============================================================================

{ TCnASService }

constructor TCnASService.Create(const CreateParam: OleVariant);
begin
  inherited Create;
end;

//==============================================================================
// ActiveScript Host 
//==============================================================================

{ ICnASHostServices }

type
  TCnASHostServices = class(TInterfacedObject, ICnASHostServices)
  public
    // 
    function CreateObject(const ServiceName: string; CreateParam: OleVariant): IUnknown; stdcall;

    // Ի
    function MessageBox(const Text, Caption: string; Flags: Integer): Integer; stdcall;
    procedure InfoDlg(const Text: string; const Caption: string = ''); stdcall;
    function InfoOk(Text: string; Caption: string = ''): Boolean; stdcall;
    procedure ErrorDlg(Text: string; Caption: string = ''); stdcall;
    procedure WarningDlg(Text: string; Caption: string = ''); stdcall;
    function QueryDlg(Text: string; DefaultNo: Boolean = False;
      Caption: string = ''): Boolean; stdcall;
    function InputQuery(const Caption, Prompt: string): string; stdcall;
  end;

// һ֧ ICnASHostServices  IDispatch Ľӿڡ
function GetCnASHostServices: IDispatch;
begin
  Result := GetIDispatchProxy(TCnASHostServices.Create, TypeInfo(ICnASHostServices));
end;

{ TCnASHostServices }

function TCnASHostServices.CreateObject(const ServiceName: string;
  CreateParam: OleVariant): IUnknown;
var
  IntfTypeInfo: PTypeInfo;
  ServiceClass: TCnASServiceClass;
begin
  ServiceClass := GetCnASServiceClass(ServiceName, IntfTypeInfo);
  if Assigned(ServiceClass) then
    Result := GetIDispatchProxy(ServiceClass.Create(CreateParam), IntfTypeInfo)
  else
    Result := nil;
end;

procedure TCnASHostServices.ErrorDlg(Text, Caption: string);
begin
  CnCommon.ErrorDlg(Text, Caption);
end;

procedure TCnASHostServices.InfoDlg(const Text, Caption: string);
begin
  CnCommon.InfoDlg(Text, Caption);
end;

function TCnASHostServices.InfoOk(Text, Caption: string): Boolean;
begin
  Result := CnCommon.InfoOk(Text, Caption);
end;

function TCnASHostServices.InputQuery(const Caption,
  Prompt: string): string;
begin
  CnCommon.CnInputQuery(Caption, Prompt, Result);
end;

function TCnASHostServices.MessageBox(const Text, Caption: string;
  Flags: Integer): Integer;
begin
  Result := Windows.MessageBox(0, PChar(Text), PChar(Caption), Flags);
end;

function TCnASHostServices.QueryDlg(Text: string; DefaultNo: Boolean;
  Caption: string): Boolean;
begin
  Result := CnCommon.QueryDlg(Text, DefaultNo, Caption);
end;

procedure TCnASHostServices.WarningDlg(Text, Caption: string);
begin
  CnCommon.WarningDlg(Text, Caption);
end;

initialization
  CnASServiceClassList := TStringList.Create;
  CnASServiceIntfTypeInfoList := TList.Create;

finalization
  FreeAndNil(CnASServiceClassList);
  FreeAndNil(CnASServiceIntfTypeInfoList);

end.
