{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnEditorOpenFile;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣļߵԪ
* Ԫߣܾ (zjy@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   ôеַϱػʽ
* Ԫʶ$Id: CnEditorOpenFile.pas 1385 2013-12-31 15:39:02Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2011.11.03 V1.2
*               Żļдļ֧
*           2003.03.06 V1.1
*               չ·Χֹ֧·
*           2002.12.06 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNEDITORWIZARD}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Menus,
  StdCtrls, IniFiles, ToolsAPI, CnConsts, CnWizUtils, CnEditorWizard, CnWizConsts,
  CnCommon;

type

//==============================================================================
// ļ
//==============================================================================

{ TCnEditorOpenFile }

  TCnEditorOpenFile = class(TCnBaseEditorTool)
  private
    class procedure DoFindFile(const FileName: string; const Info: TSearchRec;
      var Abort: Boolean);
  protected

  public
    function GetCaption: string; override;
    function GetHint: string; override;
    function GetDefShortCut: TShortCut; override;
    procedure Execute; override;
    procedure GetEditorInfo(var Name, Author, Email: string); override;

    class function SearchAndOpenFile(FileName: string): Boolean;
  end;

{$ENDIF CNWIZARDS_CNEDITORWIZARD}

implementation

{$IFDEF CNWIZARDS_CNEDITORWIZARD}

uses
  CnWizIdeUtils;

var
  SrcFile: string;
  DstFile: string;
  Found: Boolean = False;

// ָļ
function DoOpenFile(const FileName: string): Boolean;
var
  F: TSearchRec;
  AName: string;
begin
  if FindFirst(FileName, faAnyFile, F) = 0 then
  begin
    AName := _CnExtractFilePath(FileName) + (F.Name); // ȡʵļ
    FindClose(F);                                  // ΪûĿȫСд
    CnOtaOpenFile(AName);
    Result := True;
  end
  else
    Result := False;
end;

//==============================================================================
// ļ
//==============================================================================

{ TCnEditorOpenFile }

class procedure TCnEditorOpenFile.DoFindFile(const FileName: string;
  const Info: TSearchRec; var Abort: Boolean);
begin
  if SameFileName(_CnExtractFileName(FileName), SrcFile) then
  begin
    DstFile := FileName;
    Found := True;
    Abort := True;
  end;
end;

procedure TCnEditorOpenFile.Execute;
var
  FileName: string;
  Ini: TCustomIniFile;
begin
  Ini := CreateIniFile;
  try
    FileName := CnInputBox(SCnEditorOpenFileDlgCaption,
      SCnEditorOpenFileDlgHint, '', Ini);
  finally
    Ini.Free;
  end;
  
  if FileName <> '' then
    if not SearchAndOpenFile(FileName) then
    begin
      // For Vcl.Forms like
      if IsDelphiRuntime then
        FileName := FileName + '.pas'
      else
        FileName := FileName + '.cpp';

      if not SearchAndOpenFile(FileName) then
        ErrorDlg(SCnEditorOpenFileNotFind);
    end;
end;

function TCnEditorOpenFile.GetCaption: string;
begin
  Result := SCnEditorOpenFileMenuCaption;
end;

function TCnEditorOpenFile.GetDefShortCut: TShortCut;
begin
{$IFDEF DELPHI}
  Result := ShortCut(Word('O'), [ssCtrl, ssAlt]);
{$ELSE}
  Result := 0;
{$ENDIF}
end;

function TCnEditorOpenFile.GetHint: string;
begin
  Result := SCnEditorOpenFileMenuHint;
end;

procedure TCnEditorOpenFile.GetEditorInfo(var Name, Author, Email: string);
begin
  Name := SCnEditorOpenFileName;
  Author := SCnPack_Zjy;
  Email := SCnPack_ZjyEmail;
end;

class function TCnEditorOpenFile.SearchAndOpenFile(
  FileName: string): Boolean;

  function SearchAFile(F: string): Boolean;
  var
    I: Integer;
    Paths: TStrings;
    PathName: string;
  begin
    Result := True;
    Paths := TStringList.Create;
    try
      GetLibraryPath(Paths);
      for I := 0 to Paths.Count - 1 do
      begin
        PathName := MakePath(Paths[I]) + F;
        if DoOpenFile(PathName) then
          Exit;
      end;

      SrcFile := F;
      DstFile := '';
      Found := False;
      FindFile(MakePath(GetInstallDir) + 'Source\', '*.*', DoFindFile, nil, True, True);
      if Found and DoOpenFile(DstFile) then
        Exit
      else
        Result := False;
    finally
      Paths.Free;
    end;
  end;

begin
  if Pos('.', FileName) > 0 then // ļе㣬ص
  begin
    // ԭʼļ
    Result := SearchAFile(FileName);
    if Result then
      Exit;
  end;

  // е㵫ûҵû㣬ͼչ
  if IsDelphiRuntime then
    FileName := FileName + '.pas'
  else
    FileName := FileName + '.cpp';

  Result := SearchAFile(FileName);
end;

initialization
  RegisterCnEditor(TCnEditorOpenFile); // ער

{$ENDIF CNWIZARDS_CNEDITORWIZARD}
end.
