{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizHttpDownMgr;
{* |<PRE>
================================================================================
* ƣԡ༭
* Ԫƣ߳
* Ԫߣܾ zjy@cnpack.org
*     ע
* ƽ̨Win7 + Delphi 7
* ݲԣ
*   õԪʹеַѾػʽ
* Ԫʶ$Id: $
* ޸ļ¼
*           2011.07.06 V1.0
*               Ԫ
================================================================================
|</PRE>}

{$I CnWizards.inc}

interface

uses
  Windows, SysUtils, Classes, CnThreadTaskMgr, CnCommon, CnInetUtils;

const
  csRetryCount = 2; // ԶԴ

type
  TCnDownTask = class(TCnTask)
  private
    FUrl: string;
    FFileName: string;
    FUserAgent: string;
    FReferer: string;
  public
    property Url: string read FUrl;
    property UserAgent: string read FUserAgent;
    property Referer: string read FReferer;
    property FileName: string read FFileName;
  end;

  TCnDownThread = class(TCnTaskThread)
  private
   FHttp: TCnHTTP;
  protected
    procedure DoExecute; override;
  public
    destructor Destroy; override;
  end;

  TCnDownMgr = class(TCnThreadTaskMgr)
  protected
    function GetThreadClass: TCnTaskThreadClass; override;
  public
    constructor Create;
    destructor Destroy; override;
    // һ
    function NewDownload(AUrl, AFileName, AUserAgent, AReferer: string; Data: Pointer): TCnDownTask;
  end;
  
implementation

{ TCnDownMgr }

constructor TCnDownMgr.Create;
begin
  inherited Create;
end;

destructor TCnDownMgr.Destroy;
begin
  inherited;
end;

function TCnDownMgr.GetThreadClass: TCnTaskThreadClass;
begin
  Result := TCnDownThread;
end;

function TCnDownMgr.NewDownload(AUrl, AFileName, AUserAgent, AReferer: string;
  Data: Pointer): TCnDownTask;
begin
  if AUrl <> '' then
  begin
    Result := TCnDownTask.Create;
    Result.FUrl := AUrl;
    Result.FFileName := AFileName;
    Result.FUserAgent := AUserAgent;
    Result.FReferer := AReferer;
    Result.FData := Data;
    Result.TimeOut := 30 * 1000;
    AddTask(AUrl, Result);
  end
  else
    Result := nil;
end;

{ TCnDownThread }

destructor TCnDownThread.Destroy;
begin
  if FHttp <> nil then
    FHttp.Free;
  inherited;
end;

procedure TCnDownThread.DoExecute;
var
  i: Integer;
  ATask: TCnDownTask;
begin
  ATask := TCnDownTask(FTask);
  FHttp := TCnHTTP.Create;
  try
    for i := 0 to csRetryCount - 1 do
    begin
      if ATask.UserAgent <> '' then
        FHttp.UserAgent := ATask.UserAgent;
      if ATask.Referer <> '' then
        FHttp.HttpRequestHeaders.Add('Referer: ' + ATask.Referer);
      FHttp.GetFile(ATask.Url, ATask.FileName);
      if GetFileSize(ATask.FileName) > 0 then
      begin
        ATask.FStatus := tsFinished;
        Break;
      end;
    end;
  finally
    FreeAndNil(FHttp);
  end;
end;

end.

