{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnModem;
{* |<PRE>
================================================================================
* ƣͨѶ
* ԪƣCnModem׼ƽԪ
* Ԫߣܾ (zjy@cnpack.org)
*     עCnModemCnRS232ͨѶ
*           ṩATֱͨӲƽĹ
* ƽ̨PWin98SE + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6
*   õԪеַϱػʽ
* Ԫʶ$Id: CnModem.pas 1146 2012-10-24 06:25:41Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2002.04.08 V1.0
*                Ԫ
*                ע
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CnConsts, CnNetConsts, CnRS232, IniFiles;

type

//------------------------------------------------------------------------------
// ׼ƽ
//------------------------------------------------------------------------------

{ TCnModem }

  TDialResult = (drConnect, drOpenCommFail, drNoModem, drNoDialtone, drBusy,
    drNoAnswer, drNoCarrier, drTimeout, drUnknow);
  {* ModemŽ
   |<PRE>
     drConnect:         - ӳɹ
     drOpenCommFail:    - 򿪴ʧ
     drNoModem:         - ûм⵽Modem
     drNoDialtone:      - ޲
     drBusy:            - ⵽æź
     drNoAnswer:        - Ӧź
     drNoCarrier:       - ûм⵽زź
     drTimeout:         - ʱ
     drUnknow:          - δ֪
   |</PRE>}

  TATResult = (arOk, arConnect, arRing, arNoCarrier, arError, arNoDialtone,
    arBusy, arNoAnswer, arTimeout, arUnknow);
  {* ATִн
   |<PRE>
     arOk:              - ɹ
     arConnect:         - 
     arRing:            - ź
     arNoCarrier:       - ûм⵽زź
     arError:           - ִд
     arNoDialtone:      - ޲
     arBusy:            - ⵽æź
     arNoAnswer:        - Ӧź
     arTimeout:         - ʱ
     arUnknow:          - δ֪
   |</PRE>}

  TModemVolume = (mvLowest, mvLow, mvMiddle, mvHigh);
  {* Modem 
   |<PRE>
     mvLowest:          - С
     mvLow:             - С
     mvMiddle:          - е
     mvHigh:            - 
   |</PRE>}

  TRingEvent = procedure(Sender: TObject; var Answer: Boolean) of object;
  {* յ¼AnswerǷӦ}
  TConnectEvent = procedure(Sender: TObject; Rate: Integer) of object;
  {* ӳɹ¼RateΪٶ}
  TInvalidCommandEvent = procedure(Sender: TObject; const Command: string) of object;
  {* ǷAT¼Ϊ}
  TModemState = (msUnknow, msOffline, msOnline, msOnlineCommand, msConnecting);
  {* ǰModem״̬
   |<PRE>
     msUnknow:          - δ֪״̬
     msOffline:         - ״̬
     msOnline:          - ״̬
     msOnlineCommand:   - ״̬
     msConnecting:      - ״̬
   |</PRE>}
  TStateChangeEvent = procedure(Sender: TObject; State: TModemState) of object;
  {* ǰModem״̬ı¼}

  TCnModem = class(TCnRS232)
  {* ׼ƽͨѶ
   |<PRE>
     * TCnRS232ͨ򴮿ڷATƱ׼ Modem ͨѶ
     * ʹʱֱӵ Dial вӣɷִн
     *  Modem ⵽źʱ OnRing ¼
     * Hangup ɹһӣͨѶʱжϣ OnDisConnect ¼
     * ӳɹͨʹü̳ķ WriteCommData  Modem ݡ
     * ֻе Modem ״̬ʱյݲŻ OnReceiveData ¼
   |</PRE>}
  private
    { Private declarations }
    FCheckDialtone: Boolean;
    FCheckBusy: Boolean;
    FAutoAnswer: Boolean;
    FVolume: TModemVolume;
    FWaitEscapeTime: Integer;
    FWaitDialtoneTime: Integer;
    FWaitCarrierTime: Integer;
    FInitATCommand: string;
    FModemState: TModemState;
    FOnConnect: TConnectEvent;
    FOnDisConnect: TNotifyEvent;
    FOnRing: TRingEvent;
    FOnInvalidCommand: TInvalidCommandEvent;
    FOnStateChange: TStateChangeEvent;
    FWaitATResult: Boolean;
    FATResult: string;
    FConnectRate: Integer;
    procedure SetAutoAnswer(const Value: Boolean);
    procedure SetVolume(const Value: TModemVolume);
    procedure SetInitATCommand(const Value: string);
    procedure SetWaitCarrierTime(const Value: Integer);
    procedure SetWaitDialtoneTime(const Value: Integer);
    procedure SetWaitEscapeTime(const Value: Integer);
    procedure SetCheckBusy(const Value: Boolean);
    procedure SetCheckDialtone(const Value: Boolean);
    procedure SetModemState(const Value: TModemState);
    function WaitATResult(Delay: Cardinal): string;
    function SendATOk(AT: string; Delay: Cardinal = 200): Boolean;
    function StrToIntEx(const Str: string): Integer;
  protected
    { Protected declarations }
    procedure GetComponentInfo(var AName, Author, Email, Comment: string); override;

    function CommOpened: Boolean;
    function OpenComm: Boolean;
    procedure Changed;
    procedure ReceiveData(Buffer: PAnsiChar; BufferLength: WORD); override;
    procedure _SendDataEmpty; override;
    procedure Ring; virtual;
    procedure Connect(Rate: Integer); virtual;
    procedure DisConnect; virtual;
    procedure InvalidCommand(const Command: string); virtual;
    procedure Escape;
    procedure Resume;
    function Answer: TDialResult;
    property ModemState: TModemState read FModemState write SetModemState;
  public
    { Public declarations }
    procedure Assign(Source: TPersistent); override;
    {* ֵʽ}
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function InitModem: Boolean;
    {* ʼModemһ㲻Ҫֹ}
    function Dial(const Number: string): TDialResult;
    {* ŷΪԷ绰}
    procedure WriteATCommand(const Command: string; Return: Boolean = True);
    {* дATûֹ Modem AT
     |<PRE>
       Command: string  - AT
       Return: Boolean  - ǷԶĩβӻسĬΪ
     |</PRE>}
    procedure Hangup;
    {* һǰ}
    procedure ReadFromIni(Ini: TCustomIniFile; const Section: string); override;
    procedure WriteToIni(Ini: TCustomIniFile; const Section: string); override;
    property State: TModemState read FModemState;
    {* ǰ Modem ״ֻ̬}
    property ConnectRate: Integer read FConnectRate;
    {* ǰٶȣֻ}
  published
    { Published declarations }
    property CheckDialtone: Boolean read FCheckDialtone write SetCheckDialtone default
      True;
    {* ǰǷⲦ}
    property CheckBusy: Boolean read FCheckBusy write SetCheckBusy default True;
    {* ǰǷæź}
    property AutoAnswer: Boolean read FAutoAnswer write SetAutoAnswer default False;
    {* ǷԶӦ OnRing ¼ǷԶӦ}
    property Volume: TModemVolume read FVolume write SetVolume default mvMiddle;
    {* Modem }
    property WaitDialtoneTime: Integer read FWaitDialtoneTime write SetWaitDialtoneTime
      default 2;
    {* ȴʱ䣬λΪ}
    property WaitCarrierTime: Integer read FWaitCarrierTime write SetWaitCarrierTime
      default 50;
    {* ȴزʱ䣬λΪ}
    property WaitEscapeTime: Integer read FWaitEscapeTime write SetWaitEscapeTime
      default 50;
    {* л״̬ĵȴʱ䣬λΪ 20 }
    property InitATCommand: string read FInitATCommand write SetInitATCommand;
    {* ڳʼ Modem ĶAT߼ûʹ}
    property OnRing: TRingEvent read FOnRing write FOnRing;
    {* ¼}
    property OnConnect: TConnectEvent read FOnConnect write FOnConnect;
    {* ӳɹ¼}
    property OnInvalidCommand: TInvalidCommandEvent read FOnInvalidCommand write
      FOnInvalidCommand;
    {* ⵽ЧAT¼}
    property OnDisConnect: TNotifyEvent read FOnDisConnect write FOnDisConnect;
    {* ж¼}
    property OnStateChange: TStateChangeEvent read FOnStateChange write FOnStateChange;
    {* Modem ״̬ı¼}
  end;

implementation

//------------------------------------------------------------------------------
// ׼ƽ
//------------------------------------------------------------------------------

{ TCnModem }

// ֵ
procedure TCnModem.Assign(Source: TPersistent);
begin
  if Source is TCnModem then
  begin
    FCheckDialtone := TCnModem(Source).FCheckDialtone;
    FCheckBusy := TCnModem(Source).FCheckBusy;
    FAutoAnswer := TCnModem(Source).FAutoAnswer;
    FWaitEscapeTime := TCnModem(Source).FWaitEscapeTime;
    FWaitDialtoneTime := TCnModem(Source).FWaitDialtoneTime;
    FWaitCarrierTime := TCnModem(Source).FWaitCarrierTime;
    FInitATCommand := TCnModem(Source).FInitATCommand;
  end;
  inherited;
end;

// ʼ
constructor TCnModem.Create(AOwner: TComponent);
begin
  inherited;
  FCheckDialtone := True;
  FCheckBusy := True;
  FAutoAnswer := False;
  FVolume := mvMiddle;
  FWaitDialtoneTime := 2;
  FWaitCarrierTime := 50;
  FWaitEscapeTime := 50;
  FInitATCommand := '';
  FModemState := msOffline;
  FWaitATResult := False;
  FATResult := '';
  FConnectRate := 0;
  CommConfig.Outx_CtsFlow := True;
  CommConfig.Outx_DsrFlow := True;
end;

// ͷ
destructor TCnModem.Destroy;
begin
  Hangup;
  inherited;
end;

// ͨѶ״̬
function TCnModem.CommOpened: Boolean;
begin
  Result := Handle <> 0;
end;

// 򿪴ڣسɹ
function TCnModem.OpenComm: Boolean;
begin
  Result := CommOpened;
  if not Result then
  begin
    try
      StartComm;
      Result := True;
    except
      Exit;
    end;
  end;
end;

// ѱ
procedure TCnModem.Changed;
begin
  if (ComponentState * [csDesigning, csLoading, csDestroying] = [])
    and CommOpened then
    InitModem;
end;

// ݻ
procedure TCnModem._SendDataEmpty;
begin
  if ModemState = msOnline then // ״̬²¼
    inherited;
end;

// ַתΪ
function TCnModem.StrToIntEx(const Str: string): Integer;
var
  SInt: string;
  i: Integer;
begin
  SInt := '';
  for i := 1 to Length(Str) do
    if {$IFDEF DELPHI12_UP}CharInSet(Str[i], ['0'..'9']){$ELSE}Str[i] in ['0'..'9']{$ENDIF} then // ȡַ
      SInt := SInt + Str[i];
  if SInt <> '' then
    Result := StrToInt(SInt)
  else
    Result := 0;
end;

// AT
procedure TCnModem.WriteATCommand(const Command: string; Return: Boolean);
var
  s: AnsiString;
begin
  if (csDesigning in ComponentState) or not CommOpened then
    Exit;
  if Return then
    s := {$IFDEF DELPHI12_UP}AnsiString{$ENDIF}(Command) + #13
  else
    s := {$IFDEF DELPHI12_UP}AnsiString{$ENDIF}(Command);
  WriteCommData(PAnsiChar(s), Length(s));
end;

// ȴһATִн
function TCnModem.WaitATResult(Delay: Cardinal): string;
var
  Tick: Cardinal;
begin
  FWaitATResult := True;
  try
    FATResult := '';
    Tick := GetTickCount;
    while (GetTickCount - Tick < Delay) and (FATResult = '') do
      Application.HandleMessage;
    Result := FATResult;
    FATResult := '';
  finally
    FWaitATResult := False;
  end;
end;

// һATǷɹ
function TCnModem.SendATOk(AT: string; Delay: Cardinal): Boolean;
var
  i, j: Integer;
  s: string;
begin
  Result := False;
  for i := 0 to 2 do
  begin
    WriteATCommand(AT);
    for j := 0 to 2 do
    begin
      s := Trim(UpperCase(WaitATResult(Delay)));
      if Pos('OK', s) > 0 then
      begin
        Result := True;
        Exit;
      end
      else if Pos('ERROR', s) > 0 then
      begin
        InvalidCommand(AT);
        Exit;
      end;
    end;
  end;
end;

// յ
procedure TCnModem.ReceiveData(Buffer: PAnsiChar; BufferLength: WORD);
var
  s: AnsiString;
begin
  if FWaitATResult then       // ڵȴATִн
  begin
    FATResult := {$IFDEF DELPHI12_UP}String{$ENDIF}(Buffer);
    Exit;
  end;
  s := Buffer;
  s := {$IFDEF DELPHI12_UP}AnsiString{$ENDIF}(Trim(UpperCase({$IFDEF DELPHI12_UP}String{$ENDIF}(s))));
  if (ModemState in [msOffline, msOnlineCommand, msConnecting]) and (s = 'RING') then
    Ring                      // ź
  else if (ModemState = msOnline) and (s = 'NO CARRIER') then
    DisConnect                // زʧ
  else
    inherited;
end;

// 
function TCnModem.Dial(const Number: string): TDialResult;
var
  s: string;
begin
  if not OpenComm then
  begin
    Result := drOpenCommFail;
    Exit;
  end;
  Result := drNoModem;
  if InitModem then
  begin
    WriteATCommand('ATD' + Number);
    ModemState := msConnecting;
    s := Trim(UpperCase(WaitATResult(Round(WaitCarrierTime * 1000 * 1.2))));
    if Pos('CONNECT', s) > 0 then
    begin
      Result := drConnect;
      FConnectRate := StrToIntEx(s);
      ModemState := msOnline;
      Exit;
    end;
    if Pos('NO DIALTONE', s) > 0 then
      Result := drNoDialtone
    else if Pos('BUSY', s) > 0 then
      Result := drBusy
    else if Pos('NO CARRIER', s) > 0 then
      Result := drNoCarrier
    else if Pos('NO ANSWER', s) > 0 then
      Result := drNoAnswer
    else if s = '' then
      Result := drTimeout
    else
      Result := drUnknow;
    ModemState := msOffline;
  end;
end;

// Ӧ
function TCnModem.Answer: TDialResult;
var
  s: string;
begin
  Result := drUnknow;
  if CommOpened and (ModemState = msOffline) then
  begin
    WriteATCommand('ATA');
    ModemState := msConnecting;
    s := Trim(UpperCase(WaitATResult(Round(WaitCarrierTime * 1000 * 1.2))));
    if Pos('CONNECT', s) > 0 then
    begin
      FConnectRate := StrToIntEx(s);
      ModemState := msOnline;
      Connect(FConnectRate);
      Result := drConnect;
      Exit;
    end;
    if Pos('NO DIALTONE', s) > 0 then
      Result := drNoDialtone
    else if Pos('BUSY', s) > 0 then
      Result := drBusy
    else if Pos('NO CARRIER', s) > 0 then
      Result := drNoCarrier
    else if Pos('NO ANSWER', s) > 0 then
      Result := drNoAnswer
    else if s = '' then
      Result := drTimeout
    else
      Result := drUnknow;
    ModemState := msOffline;
  end;
end;

// л״̬
procedure TCnModem.Escape;
var
  Tick: Integer;
begin
  if CommOpened and (ModemState = msOnline) then
  begin
    Tick := Round(FWaitEscapeTime * 20 * 1.3);
    Sleep(Tick);
    WriteATCommand('+++', False);
    Sleep(Tick);
    ModemState := msOnlineCommand;
  end;
end;

// ص״̬
procedure TCnModem.Resume;
begin
  if CommOpened and (ModemState = msOnlineCommand) then
  begin
    if SendATOk('ATO') then
      ModemState := msOnline
    else
      Hangup;
  end;
end;

// һ
procedure TCnModem.Hangup;
begin
  if CommOpened then
  begin
    Escape;
    WriteATCommand('ATH');
    Sleep(1000);
    ModemState := msOffline;
    StopComm;
  end;
end;

// ʼ Modem
function TCnModem.InitModem: Boolean;
const
  AutoAnswers: array[Boolean] of Integer = (0, 1);
  Checks: array[Boolean, Boolean] of Integer = ((0, 2), (3, 4));
begin
  Result := False;
  if not OpenComm then
    Exit;
  if ModemState <> msOffline then
    Hangup;
  if not SendATOk('ATQ0E0V1') then Exit; //ԣַʽʾ
  if not SendATOk('ATX' + IntToStr(Checks[CheckDialtone, CheckBusy])) then Exit;
  if not SendATOk('ATL' + IntToStr(Ord(FVolume))) then Exit;
  if not SendATOk('ATS0=' + IntToStr(AutoAnswers[AutoAnswer])) then Exit;
  if not SendATOk('ATS6=' + IntToStr(WaitDialtoneTime)) then Exit;
  if not SendATOk('ATS7=' + IntToStr(WaitCarrierTime)) then Exit;
  if not SendATOk('ATS12=' + IntToStr(WaitEscapeTime)) then Exit;
  Result := True;
  if InitATCommand <> '' then
    SendATOk(InitATCommand);
end;

// ǷAT
procedure TCnModem.InvalidCommand(const Command: string);
begin
  if Assigned(FOnInvalidCommand) then
    FOnInvalidCommand(Self, Command);
end;

// 
procedure TCnModem.Connect(Rate: Integer);
begin
  if Assigned(FOnConnect) then
    FOnConnect(Self, Rate);
end;

// ж
procedure TCnModem.DisConnect;
begin
  if Assigned(FOnDisConnect) then
    FOnDisConnect(Self);
end;

// ¼
procedure TCnModem.Ring;
var
  Ans: Boolean;
begin
  Ans := True;
  if Assigned(FOnRing) then
    FOnRing(Self, Ans);
  if not AutoAnswer and Ans then
    Answer;
end;

// Modem״̬
procedure TCnModem.SetModemState(const Value: TModemState);
begin
  if FModemState <> Value then
  begin
    FModemState := Value;
    if Assigned(FOnStateChange) then
      FOnStateChange(Self, FModemState);
  end;
end;

// ԶӦ
procedure TCnModem.SetAutoAnswer(const Value: Boolean);
begin
  if FAutoAnswer <> Value then
  begin
    FAutoAnswer := Value;
    Changed;
  end;
end;

// 
procedure TCnModem.SetVolume(const Value: TModemVolume);
begin
  if FVolume <> Value then
  begin
    FVolume := Value;
    Changed;
  end;
end;

// óʼAT
procedure TCnModem.SetInitATCommand(const Value: string);
begin
  if FInitATCommand <> Value then
  begin
    FInitATCommand := UpperCase(Trim(Value));
    if Pos('AT', FInitATCommand) <> 1 then
      FInitATCommand := 'AT' + FInitATCommand;
    if FInitATCommand = 'AT' then
      FInitATCommand := '';
    Changed;
  end;
end;

// õȴزʱ
procedure TCnModem.SetWaitCarrierTime(const Value: Integer);
begin
  if FWaitCarrierTime <> Value then
  begin
    FWaitCarrierTime := Value;
    Changed;
  end;
end;

// õȴʱ
procedure TCnModem.SetWaitDialtoneTime(const Value: Integer);
begin
  if FWaitDialtoneTime <> Value then
  begin
    FWaitDialtoneTime := Value;
    Changed;
  end;
end;

// л״̬ĵȴʱ
procedure TCnModem.SetWaitEscapeTime(const Value: Integer);
begin
  if FWaitEscapeTime <> Value then
  begin
    FWaitEscapeTime := Value;
    Changed;
  end;
end;

// üæ
procedure TCnModem.SetCheckBusy(const Value: Boolean);
begin
  if FCheckBusy <> Value then
  begin
    FCheckBusy := Value;
    Changed;
  end;
end;

// üⲦ
procedure TCnModem.SetCheckDialtone(const Value: Boolean);
begin
  if FCheckDialtone <> Value then
  begin
    FCheckDialtone := Value;
    Changed;
  end;
end;

const
  csCheckDialtone = 'CheckDialtone';
  csCheckBusy = 'CheckBusy';
  csAutoAnswer = 'AutoAnswer';
  csWaitEscapeTime = 'WaitEscapeTime';
  csWaitDialtoneTime = 'WaitDialtoneTime';
  csWaitCarrierTime = 'WaitCarrierTime';
  csInitATCommand = 'InitATCommand';

// INIж
procedure TCnModem.ReadFromIni(Ini: TCustomIniFile;
  const Section: string);
begin
  inherited;
  FCheckDialtone := Ini.ReadBool(Section, csCheckDialtone, FCheckDialtone);
  FCheckBusy := Ini.ReadBool(Section, csCheckBusy, FCheckBusy);
  FAutoAnswer := Ini.ReadBool(Section, csAutoAnswer, FAutoAnswer);
  FWaitEscapeTime := Ini.ReadInteger(Section, csWaitEscapeTime, FWaitEscapeTime);
  FWaitDialtoneTime := Ini.ReadInteger(Section, csWaitDialtoneTime, FWaitDialtoneTime);
  FWaitCarrierTime := Ini.ReadInteger(Section, csWaitCarrierTime, FWaitCarrierTime);
  FInitATCommand := Ini.ReadString(Section, csInitATCommand, FInitATCommand);
  FInitATCommand := UpperCase(Trim(FInitATCommand));
  if Pos('AT', FInitATCommand) <> 1 then
    FInitATCommand := 'AT' + FInitATCommand;
  if FInitATCommand = 'AT' then
    FInitATCommand := '';
end;

// дINI
procedure TCnModem.WriteToIni(Ini: TCustomIniFile; const Section: string);
begin
  inherited;
  Ini.WriteBool(Section, csCheckDialtone, FCheckDialtone);
  Ini.WriteBool(Section, csCheckBusy, FCheckBusy);
  Ini.WriteBool(Section, csAutoAnswer, FAutoAnswer);
  Ini.WriteInteger(Section, csWaitEscapeTime, FWaitEscapeTime);
  Ini.WriteInteger(Section, csWaitDialtoneTime, FWaitDialtoneTime);
  Ini.WriteInteger(Section, csWaitCarrierTime, FWaitCarrierTime);
  Ini.WriteString(Section, csInitATCommand, FInitATCommand);
end;

// ȡע
procedure TCnModem.GetComponentInfo(var AName, Author, Email, Comment: string);
begin
  AName := SCnModemName;
  Author := SCnPack_Zjy;
  Email := SCnPack_ZjyEmail;
  Comment := SCnModemComment;
end;

end.

