{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnViewOption;
{ |<PRE>
================================================================================
* ƣCnDebugViewer
* Ԫƣô嵥Ԫ
* ԪߣСkend kending@21cn.com
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7
*   õԪеֱַ֧ػʽ
* Ԫʶ$Id: CnViewOption.pas 1146 2012-10-24 06:25:41Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2008.01.18
*               Sesame: ӱλѡ
*           2005.01.01
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, CnLangMgr;

type
  TCnViewerOptionsFrm = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    chkMinToTrayIcon: TCheckBox;
    chkCloseToTrayIcon: TCheckBox;
    hkShowFormHotKey: THotKey;
    grpTrayIcon: TGroupBox;
    chkShowTrayIcon: TCheckBox;
    grpCapture: TGroupBox;
    chkCapDebug: TCheckBox;
    lblCapOD: TLabel;
    lblHotKey: TLabel;
    chkMinStart: TCheckBox;
    chkSaveFormPosition: TCheckBox;
    procedure chkShowTrayIconClick(Sender: TObject);
  private
    { Private declarations }
    procedure SwitchTrayIconControls(const AShow: Boolean);
  protected
    procedure DoCreate; override;    
  public
    { Public declarations }
    procedure LoadFromOptions;
    procedure SaveToOptions;
  end;

implementation

uses CnViewCore;

{$R *.dfm}

{ TCnViewerOptionsFrm }

procedure TCnViewerOptionsFrm.DoCreate;
begin
  inherited;
  CnLanguageManager.TranslateForm(Self);
end;

procedure TCnViewerOptionsFrm.LoadFromOptions;
begin
  with CnViewerOptions do
  begin
    chkMinStart.Checked := StartMin;
    chkShowTrayIcon.Checked := ShowTrayIcon;
    chkMinToTrayIcon.Checked := MinToTrayIcon;
    chkCloseToTrayIcon.Checked := CloseToTrayIcon;
    chkSaveFormPosition.Checked := SaveFormPosition;
    hkShowFormHotKey.HotKey := MainShortCut;
    chkCapDebug.Checked := not IgnoreODString;
    SwitchTrayIconControls(ShowTrayIcon);
  end;
end;

procedure TCnViewerOptionsFrm.SaveToOptions;
begin
  with CnViewerOptions do
  begin
    StartMin := chkMinStart.Checked;
    ShowTrayIcon := chkShowTrayIcon.Checked;
    MinToTrayIcon := chkMinToTrayIcon.Checked;
    CloseToTrayIcon := chkCloseToTrayIcon.Checked;
    SaveFormPosition := chkSaveFormPosition.Checked;
    MainShortCut := hkShowFormHotKey.HotKey;
    IgnoreODString := not chkCapDebug.Checked;
  end;
end;

procedure TCnViewerOptionsFrm.SwitchTrayIconControls(const AShow: Boolean);
begin
  chkMinToTrayIcon.Enabled := AShow;
  chkCloseToTrayIcon.Enabled := AShow;
end;

procedure TCnViewerOptionsFrm.chkShowTrayIconClick(Sender: TObject);
begin
  SwitchTrayIconControls(chkShowTrayIcon.Checked);
end;

end.
