{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnDHibernatePodoList;
{* |<PRE>
================================================================================
* ƣCnDHibernate׼
* ԪƣPODO /൥Ԫ
* ԪߣRarnu (rarnu@cnpack.org)
*     ע
*
*      ʹʾ
*
*      objList := TRaObjList.Create;
*      obj := 'obj';
*      obj.add('id', TObject(obj));
*      showMessage(string(obj.getObjectByName('id')));
*
* ƽ̨PWinXP SP2 + Delphi 2009
* ݲԣWin2000/XP/Vista/2008 + Delphi 2009
*   õԪеַϱػʽ
* Ԫʶ$Id: CnDHibernatePodoList.pas 1146 2012-10-24 06:25:41Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2008.08.23 V1.8
*               ֲ Delphi2009
*           2006.09.04 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

{$IFDEF SUPPORT_ADO}

uses
  Classes, SysUtils;

const
  // 쳣ַ
  OUT_OF_OBJECT_INDEX_EXCEPTION_STRING = 'б±';
  NAME_NOT_FOUND_EXCEPTION_STRING = ' id ';

  (******************************************************************************)

type
  // 쳣
  // 쳣ж index ʱʹ
  //  index Χ׳쳣
  TCnOutOfObjectIndexException = Exception;

  // 쳣ж϶ id ʱʹ
  // û id׳쳣
  TCnNameNotFoundException = Exception;

  (******************************************************************************)

    // ¼
    // ˼¼ hash һ
    // ͨ   
    // ƿԲΨһ
    // ǸƲҶʱ
    // ظôֻȡһƥ
    // Ϊգֻͨ index ȡ
  TCnObjectRec = record
    // 
    id: string;
    // 
    obj: TObject;
  end;                                   { TCnObjectRec }

  (******************************************************************************)

    // б
    // öڱб
    // ҿȡ

  TCnPodoList = class
  private

    // б
    // бʹ TCnObjectRec ¼
    // γ hash Ľṹ
    // ʵʲʱʹõֵ
    objList: array of TCnObjectRec;

    // ȡָŵĶ
    // 󶨵 Objects 
    function GetObject(index: integer): TObject;
    procedure SetObject(index: integer; obj: TObject);
    // ȡ id б
    // 󶨵 IdList 
    function getIdList: TStringList;
    function GetCount: integer;
  protected
  public
    // б
    procedure Clear;
    // Ӷ
    procedure Add(obj: TObject); overload;
    // Ӷ󣬴 id
    procedure Add(Id: string; obj: TObject); overload;
    //  index 
    procedure Insert(index: Integer; obj: TObject); overload;
    //  index 󣬴 id
    procedure Insert(index: Integer; id: string; obj: TObject); overload;
    // Ƴ index Ķ
    procedure Remove(index: Integer); overload;
    // Ƴ obj  
    function Remove(obj: TObject): boolean; overload;
    // ȡһ
    function IndexOf(obj: TObject): integer;
    // ȡ
    function LastIndexOf(obj: TObject): integer;
    // ƻȡ
    function getObjectByName(ObjName: string): TObject;
    // ƶ
    procedure move(oldIndex, newIndex: integer);
  public
    // 
    property Objects[index: integer]: TObject read GetObject write SetObject;
    // б
    property IdList: TStringList read getIdList;
    // 
    property Count: integer read GetCount;
  end;                                   

  (******************************************************************************)

{$ENDIF SUPPORT_ADO}

implementation

{$IFDEF SUPPORT_ADO}

{ TCnPodoList }

/// <summary>
/// Ӷб
/// </summary>
/// <param name="obj"></param>
procedure TCnPodoList.Add(obj: TObject);
var
  id: string;
begin
  //  id Ϊ
  id := EmptyStr;
  // ô 2 ӷ
  Add(id, obj);
end;                                     { Add }

/// <summary>
/// Ӷб id
/// </summary>
/// <param name="Id">ʶ</param>
/// <param name="obj"></param>

procedure TCnPodoList.Add(Id: string; obj: TObject);
var
  Len: Integer;
begin
  // ȡб
  Len := Length(objList);
  // ó + 1
  SetLength(objList, Len + 1);
  // Ϊ hash ֵ
  objList[Len].id := Id;
  objList[Len].obj := obj;
end;                                     { Add }

(******************************************************************************)

/// <summary>
/// նб
/// </summary>

procedure TCnPodoList.Clear;
begin
  // еĶÿ
  // ڲ
  SetLength(objList, 0);
end;                                     { Clear }

function TCnPodoList.GetCount: integer;
begin
  Result := Length(objList);
end;                                     { GetCount }

(******************************************************************************)

/// <summary>
/// ȡ id б
/// </summary>
/// <returns>б</returns>

function TCnPodoList.getIdList: TStringList;
var
  i: Integer;
begin
  //  id бʵ
  Result := TStringList.Create;
  // беĶ id ӵ id б
  for i := 0 to Length(objList) - 1 do
    Result.Add(objlist[i].id);
end;                                     { getIdList }

(******************************************************************************)

/// <summary>
/// ƻȡ
/// </summary>
/// <param name="ObjName"></param>
/// <returns></returns>

function TCnPodoList.getObjectByName(ObjName: string): TObject;
var
  i: Integer;
begin
  // жǷ
  if ObjName = EmptyStr then
  begin
    // ׳쳣
    raise TCnNameNotFoundException.Create(NAME_NOT_FOUND_EXCEPTION_STRING);
    Exit;
  end;                                   { if }

  // ʼض
  Result := nil;
  for i := 0 to Length(objList) - 1 do
  begin
    //  id 봫ͬ
    if objList[i].id = ObjName then
    begin
      // ش˶󲢽ѭ
      Result := objlist[i].obj;
      Break;
    end;                                 { if }
  end;                                   { for }
end;                                     { getObjectByName }

(******************************************************************************)

/// <summary>
/// ȡָŵĶ
/// </summary>
/// <param name="index"></param>
/// <returns></returns>

function TCnPodoList.GetObject(index: integer): TObject;
begin
  // жǷ񳬳±
  if (index < 0) or (index > Length(objList)) then
  begin
    // ׳쳣
    raise TCnOutOfObjectIndexException.Create(OUT_OF_OBJECT_INDEX_EXCEPTION_STRING);
    Exit;
  end;                                   { if }
  // ض
  Result := objlist[index].obj;
end;
                                  { GetObject }
(******************************************************************************)

/// <summary>
/// ָŵĶ
/// </summary>
/// <param name="index"></param>
/// <param name="obj"></param>
//  SetObject by  1.6 

procedure TCnPodoList.SetObject(index: integer; obj: TObject);
begin
  // жǷ񳬳±
  if (index < 0) or (index > Length(objList)) then
  begin
    // ׳쳣
    raise TCnOutOfObjectIndexException.Create(OUT_OF_OBJECT_INDEX_EXCEPTION_STRING);
    Exit;
  end;                                   { if }
  // ض
  objlist[index].obj := obj;
end;
                                  { GetObject }
(******************************************************************************)

/// <summary>
/// ȡָĶ
/// </summary>
/// <param name="obj"></param>
/// <returns></returns>

function TCnPodoList.IndexOf(obj: TObject): integer;
var
  i: Integer;
begin
  // ʼֵΪ -1
  // ˷ֵʾδҵصĶ
  Result := -1;
  for i := 0 to Length(objList) - 1 do
  begin
    // бд˶
    if objList[i].obj = obj then
    begin
      // ضŲѭ
      Result := i;
      Break;
    end;                                 { if }
  end;                                   { for }
end;                                     { IndexOf }


(******************************************************************************)

/// <summary>
/// ȡһ
/// </summary>
/// <param name="obj"></param>
/// <returns></returns>
//  LastIndexOf  by  1.6 

function TCnPodoList.LastIndexOf(obj: TObject): integer;
var
  i: Integer;
begin
  // ʼֵΪ -1
  // ˷ֵʾδҵصĶ
  Result := -1;
  for i := Length(objList) - 1 downto 0 do
  begin
    // бд˶
    if objList[i].obj = obj then
    begin
      // ضŲѭ
      Result := i;
      Break;
    end;                                 { if }
  end;                                   { for }
end;

(******************************************************************************)

/// <summary>
///  index 󣬴 id
/// </summary>
/// <param name="index"></param>
/// <param name="id">ʶ</param>
/// <param name="obj"></param>
procedure TCnPodoList.Insert(index: Integer; id: string; obj: TObject);
var
  i: Integer;
  len: Integer;
begin
  // С㣬㴦
  if index < 0 then
    index := 0;

  // Ŵб
  // б
  if index > Length(objList) - 1 then
  begin
    Add(id, obj);
    Exit;
  end;                                   { if }

  // г + 1
  len := Length(objList);
  SetLength(objList, len + 1);

  // ˳
  for i := len downto index + 1 do
  begin
    objList[i].id := objList[i - 1].id;
    objList[i].obj := objList[i - 1].obj;
  end;                                   { for }

  // 뵽 index 
  objList[index].id := id;
  objList[index].obj := obj;
end;                                     { Insert }

/// <summary>
/// Ŵ
/// </summary>
/// <param name="index"></param>
/// <param name="obj"></param>

procedure TCnPodoList.Insert(index: Integer; obj: TObject);
var
  id: string;
begin
  //  id ÿ
  id := EmptyStr;
  // ô 3 Ĳ뷽
  Insert(index, id, obj);
end;

(******************************************************************************)

/// <summary>
/// Ƴ
/// </summary>
/// <param name="index"></param>
procedure TCnPodoList.Remove(index: Integer);
var
  i: Integer;
begin
  // жǷ񳬳±
  if (index < 0) or (index > Length(objList)) then
  begin
    // ׳쳣
    raise TCnOutOfObjectIndexException.Create(OUT_OF_OBJECT_INDEX_EXCEPTION_STRING);
    Exit;
  end;                                   { if }

  // Ƴ
  // Ķ
  for i := index to Length(objList) - 2 do
  begin
    objList[i].id := objlist[i + 1].id;
    objList[i].obj := objlist[i + 1].obj;
  end;                                   { for }

  // һȥ
  SetLength(objList, Length(objList) - 1);
end;

(******************************************************************************)

/// <summary>
/// objcetƳ
/// </summary>
/// <param name="index"></param>
//  Remove by  1.6 
function TCnPodoList.Remove(obj: TObject): boolean;
var
  index: Integer;
begin
  index := indexof(obj);
  if index < 0 then
    result := false
  else
  begin
    Remove(index);
    result := true;
  end;
end;

procedure TCnPodoList.move(oldIndex, newIndex: integer);
var
  obj: TObject;
begin
  // get object at old index
  obj := Objects[oldIndex];
  // remove old obj
  Remove(oldIndex);
  // insert the object at the new index
  Insert(newIndex, obj);
end;

{$ENDIF SUPPORT_ADO}
end.
