{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnBookmarkConfigFrm;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣǩô嵥Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   ôеַϱػʽ
* Ԫʶ$Id: CnBookmarkConfigFrm.pas 1298 2013-07-19 01:51:27Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2002.11.24 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNBOOKMARKWIZARD}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, CnSpin, CnWizOptions, CnWizMultiLang;

type
  TCnBookmarkConfigForm = class(TCnTranslateForm)
    btnOK: TButton;
    btnCancel: TButton;
    gbBrowse: TGroupBox;
    btnSourceFont: TButton;
    btnHighlightFont: TButton;
    Label1: TLabel;
    Label2: TLabel;
    gwBookmark: TGroupBox;
    cbSaveBookmark: TCheckBox;
    SourceFontDialog: TFontDialog;
    HighlightFontDialog: TFontDialog;
    chkAutoRefresh: TCheckBox;
    seDispLines: TCnSpinEdit;
    lbl1: TLabel;
    seInterval: TCnSpinEdit;
    lbl2: TLabel;
    procedure btnSourceFontClick(Sender: TObject);
    procedure btnHighlightFontClick(Sender: TObject);
    procedure seDispLinesKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function ShowBookmarkConfigForm(var DispLines: Integer; var SaveBookmark,
  AutoRefresh: Boolean; var Interval: Integer; SourceFont, HighlightFont:
  TFont): Boolean;

{$ENDIF CNWIZARDS_CNBOOKMARKWIZARD}

implementation

{$IFDEF CNWIZARDS_CNBOOKMARKWIZARD}

{$R *.DFM}

function ShowBookmarkConfigForm(var DispLines: Integer; var SaveBookmark,
  AutoRefresh: Boolean; var Interval: Integer; SourceFont, HighlightFont:
  TFont): Boolean;
begin
  with TCnBookmarkConfigForm.Create(nil) do
  try
    ShowHint := WizOptions.ShowHint;
    seDispLines.Value := DispLines;
    cbSaveBookmark.Checked := SaveBookmark;
    chkAutoRefresh.Checked := AutoRefresh;
    seInterval.Value := Interval;
    SourceFontDialog.Font.Assign(SourceFont);
    HighlightFontDialog.Font.Assign(HighlightFont);
    Result := ShowModal = mrOk;
    if Result then
    begin
      DispLines := seDispLines.Value;
      SaveBookmark := cbSaveBookmark.Checked;
      AutoRefresh := chkAutoRefresh.Checked;
      Interval := seInterval.Value;
      SourceFont.Assign(SourceFontDialog.Font);
      HighlightFont.Assign(HighlightFontDialog.Font);
    end;
  finally
    Free;
  end;
end;

procedure TCnBookmarkConfigForm.btnSourceFontClick(Sender: TObject);
begin
  SourceFontDialog.Execute;
end;

procedure TCnBookmarkConfigForm.btnHighlightFontClick(Sender: TObject);
begin
  HighlightFontDialog.Execute;
end;

procedure TCnBookmarkConfigForm.seDispLinesKeyPress(Sender: TObject;
  var Key: Char);
begin   
  if Key = #27 then
  begin
    ModalResult := mrCancel;
    Key := #0;
  end
  else
  if Key = #13 then
  begin
    ModalResult := mrOk;
    Key := #0;
  end
end;

{$ENDIF CNWIZARDS_CNBOOKMARKWIZARD}
end.
