{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnIISCtrl;

{* |<PRE>
================================================================================
* ƣͨѶ
* ԪƣʵIISùܵԪ
* Ԫߣrarnu(rarnu@cnpack.org)
*     ע
* ƽ̨Windows2003 Server + Delphi2007 up2
* ݲԣWindows2000/XP/2003/Vista + Delphi 7/2006/2007/2009
*   õԪеַϱػʽ
* Ԫʶ$Id: CnIISCtrl.pas 1146 2012-10-24 06:25:41Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2008.08.14 V1.0
*                Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, ComObj, Windows;

type
  TCnIISCtrl = class(TComponent)
  private
    FOnDeleteVirtualDirApp: TNotifyEvent;
    FOnDeleteVirtualDir: TNotifyEvent;
    FOnCreateVirtualDir: TNotifyEvent;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    {* Ƿ .NET FrameWork }
    function CheckDotNetFramework: Boolean;
    {* ɾĿ¼Ӧó }
    function DeleteVirtualDirApp(strVirtualDir: string): Boolean;
    {* ɾĿ¼ }
    function DeleteVirtualDir(strVirtualDir: string): Boolean;
    {* ǷĿ¼ }
    function CheckVirtualDir(const strVirtualDir: string): Boolean;
    {* Ŀ¼ }
    function CreateVirtualDir(const strVirtualDir, strDir, strAppName: string): Boolean;
  published
    {* ɾĿ¼Ӧóʱ¼ }
    property OnDeleteVirtualDirApp: TNotifyEvent read FOnDeleteVirtualDirApp write FOnDeleteVirtualDirApp;
    {* ɾĿ¼ʱ¼ }
    property OnDeleteVirtualDir: TNotifyEvent read FOnDeleteVirtualDir write FOnDeleteVirtualDir;
    {* Ŀ¼ʱ¼ }
    property OnCreateVirtualDir: TNotifyEvent read FOnCreateVirtualDir write FOnCreateVirtualDir;
  end;

implementation

{ TCnIISCtrl }

function TCnIISCtrl.CheckDotNetFramework: Boolean;
var
  SysDir: pchar;
begin
  GetMem(SysDir, 250);
  GetSystemDirectory(SysDir, 250);
  if not FileExists(SysDir + '\MSCOREE.DLL') then
    Result := False
  else
    Result := True;
  FreeMem(SysDir);
end;

function TCnIISCtrl.CheckVirtualDir(const strVirtualDir: string): Boolean;
var
  WebSite, WebServer, WebRoot: Variant;
begin
  Result := True;
  try
    WebSite := CreateOleObject('IISNamespace');
    WebSite := WebSite.GetObject('IIsWebService', 'localhost/w3svc');
    WebServer := WebSite.GetObject('IIsWebServer', '1');
    WebRoot := WebServer.GetObject('IIsWebVirtualDir', 'Root');
    WebRoot.GetObject('IIsWebVirtualDir', strVirtualDir);
  except
    Result := False;
  end;
end;

constructor TCnIISCtrl.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

function TCnIISCtrl.CreateVirtualDir(const strVirtualDir, strDir,
  strAppName: string): Boolean;
var
  WebSite, WebServer, WebRoot, vdir: Variant;
begin
  Result := True;
  try
    WebSite := CreateOleObject('IISNamespace');
    WebSite := WebSite.GetObject('IIsWebService', 'localhost/w3svc');
    WebServer := WebSite.GetObject('IIsWebServer', '1');
    WebRoot := WebServer.GetObject('IIsWebVirtualDir', 'Root');
    vdir := WebRoot.Create('IIsWebVirtualDir', strVirtualDir);
    vdir.AccessRead := True;                    // ȡ
    vdir.AccessScript := True;                  // ִΪű
    vdir.DefaultDoc := 'index.aspx,index.asp';  // Ĭĵ
    vdir.EnableDirBrowsing := False;            // Ŀ¼
    vdir.AppFriendlyName := strAppName;         // Ӧó
    vdir.Path := strDir;                        // Ŀ¼ʵ·
    vdir.AppCreate(True);                       // Ŀ¼ԶӦó
    vdir.SetInfo;
  except
    Result := False;
  end;

  (************************************************************)
  (*       IIS бڴˣɸҪ޸           *)
  (*                                                          *)
  (*  vdir.AccessWrite   := True;   // д               *)
  (*  vdir.AccessSource  := True;   // űԴ       *)
  (*  vdir.AccessExecute := True;   // ִļ         *)
  (************************************************************)

  if Assigned(FOnCreateVirtualDir) then
    FOnCreateVirtualDir(Self);
end;

function TCnIISCtrl.DeleteVirtualDir(strVirtualDir: string): Boolean;
var
  WebSite, WebServer, WebRoot: Variant;
begin
  Result := True;
  try
    WebSite := CreateOleObject('IISNamespace');
    WebSite := WebSite.GetObject('IIsWebService', 'localhost/w3svc');
    WebServer := WebSite.GetObject('IIsWebServer', '1');
    WebRoot := WebServer.GetObject('IIsWebVirtualDir', 'Root');
    WebRoot.Delete('IIsWebVirtualDir', strVirtualDir);
  except
    Result := False;
  end;
  if Assigned(FOnDeleteVirtualDir) then
    FOnDeleteVirtualDir(Self);
end;

function TCnIISCtrl.DeleteVirtualDirApp(strVirtualDir: string): Boolean;
var
  WebSite, WebServer, WebRoot, vdir: Variant;
begin
  Result := True;
  try
    WebSite := CreateOleObject('IISNamespace');
    WebSite := WebSite.GetObject('IIsWebService', 'localhost/w3svc');
    WebServer := WebSite.GetObject('IIsWebServer', '1');
    WebRoot := WebServer.GetObject('IIsWebVirtualDir', 'Root');
    vdir := WebRoot.GetObject('IIsWebVirtualDir', strVirtualDir);
    vdir.AppDelete;
    vdir.SetInfo;
  except
    Result := False;
  end;
  if Assigned(FOnDeleteVirtualDirApp) then
    FOnDeleteVirtualDirApp(Self);
end;

end.
