{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program GraphicDemo;

uses
  Windows, SysUtils, Classes, Graphics, Dialogs, ExtDlgs, ComCtrls, Menus, Forms;

var
  Form: TForm;
  Menu: TMainMenu;
  pb: TProgressBar;

function AddNewMenu(Parent: TMenuItem; Caption: string; OnClick: TNotifyEvent): TMenuItem;
begin
  Result := TMenuItem.Create(Parent);
  Result.Caption := Caption;
  Result.OnClick := OnClick;
  Parent.Add(Result);
end;

procedure OnClear(Sender: TObject);
begin
  Form.Invalidate;
end;

procedure OnDraw1(Sender: TObject);
var
  x, y: Integer;
begin
  pb.Max := Form.ClientWidth - 1;
  pb.Position := 0;
  for x := 0 to Form.ClientWidth - 1 do
  begin
    for y := 0 to Form.ClientHeight - 1 do
    begin
      Form.Canvas.Pixels[x, y] := (x and $FF) shl 16 + (y and $FF) shl 8 + $80;
    end;
    pb.Position := x;
  end;
end;

procedure OnDraw2(Sender: TObject);
var
  Bmp: TBitmap;
  x, y: Integer;
  P: Pointer;
begin
  Bmp := TBitmap.Create;
  try
    Bmp.Width := Form.ClientWidth;
    Bmp.Height := Form.ClientHeight;
    Bmp.PixelFormat := pf24bit;
    pb.Max := Bmp.Height - 1;
    pb.Position := 0;
    for y := 0 to Bmp.Height - 1 do
    begin
      P := Bmp.ScanLine[y];
      for x := 0 to Bmp.Width - 1 do
      begin
        // Script doesn't support Pointer directly, Pointer was declared as Cardinal.
        // Here use _SetXXX function to set value.
        _SetByte(P + x * 3, x and $FF);
        _SetByte(P + x * 3 + 1, y and $FF);
        _SetByte(P + x * 3 + 2, (x + y) and $FF);
      end;
      pb.Position := y;
    end;
    Form.Canvas.Draw(0, 0, Bmp);
  finally
    Bmp.Free;
  end;
end;

procedure OnDraw3(Sender: TObject);
begin
  with Form.Canvas do
  begin
    Font.Size := 25;
    Font.Name := 'Aprial';
    Brush.Style := bsSolid;
    Brush.Color := clRed;
    Ellipse(10, 23, 150, 100);
    Brush.Style := bsClear;
    TextOut(20, 80, 'Hello world!');
    Pen.Style := psDashDotDot;
    Pen.Color := clGreen;
    MoveTo(20, 50);
    LineTo(120, 200);
  end;
end;

procedure OnDraw4(Sender: TObject);
var
  pic: TPicture;
begin
  pic := TPicture.Create;
  try
    with TOpenPictureDialog.Create(nil) do
    try
      if Execute then
      begin
        pic.LoadFromFile(FileName);
        Form.Canvas.Draw(0, 0, pic.Graphic);
      end;
    finally
      Free;
    end;
  finally
    pic.Free;
  end;
end;

begin
  Form := TForm.Create(nil);
  try
    Form.SetBounds(100, 100, 400, 300);
    Form.Position := poScreenCenter;
    Form.Caption := 'Graphic Demo2';
    pb := TProgressBar.Create(Form);
    pb.Parent := Form;
    pb.Align := alBottom;
    Menu := TMainMenu.Create(Form);
    AddNewMenu(Menu.Items, 'Clear', @OnClear);
    AddNewMenu(Menu.Items, 'Draw1', @OnDraw1);
    AddNewMenu(Menu.Items, 'Draw2', @OnDraw2);
    AddNewMenu(Menu.Items, 'Draw3', @OnDraw3);
    AddNewMenu(Menu.Items, 'Draw4', @OnDraw4);
    Form.Menu := Menu;
    Form.ShowModal;
  finally
    Form.Free;
  end;
end.
