{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnEditorCodeTool;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣѡı༭
* Ԫߣܾ (zjy@cnpack.org)
*     עûѡıĴ༭
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеֱַ֧ػʽ
* Ԫʶ$Id: CnEditorCodeTool.pas 1146 2012-10-24 06:25:41Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2005.01.25 V1.2
*               ֲ GetText ܶȡ󳤶ȴȱ
*           2004.08.22 V1.1
*               ӴȫԪļѡ
*           2003.03.23 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNEDITORWIZARD}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, IniFiles, ToolsAPI, CnWizClasses, CnWizUtils, CnConsts, CnCommon,
  CnEditorWizard, CnWizConsts;

type

//==============================================================================
// ѡı༭
//==============================================================================

{ TCnEditorCodeTool }

  TCnCodeToolStyle = (csLine, csSelText, csAllText);
  {* ıķʽcsLine ΪѡзʽcsSelText/csAllTextΪѡ/ȫıʽ}

  TCnEditorCodeTool = class(TCnBaseEditorTool)
  {* ѡ봦߻ࡣ
     ûûѡıûѡ˴ִиñ༭ߣ
     ѡĴת}
  private
    FValidInSource: Boolean;
    FBlockMustNotEmpty: Boolean;
  protected
    property ValidInSource: Boolean read FValidInSource write FValidInSource;
    {* ֻԴļЧ }
    property BlockMustNotEmpty: Boolean read FBlockMustNotEmpty write
      FBlockMustNotEmpty;
    {* ֻеѡ鲻ΪʱЧ }
    function ProcessLine(const Str: string): string; virtual;
    {* ѡ Style Ϊ csLine зʽʹø÷ÿһд룬
       ʱɲ ProcessText }
    function ProcessText(const Text: string): string; virtual;
    {* ѡ Style Ϊ csSelText/csAllText ȫıʽϣԼ
       Ӧظ÷ʱ ProcessLine }
    function GetStyle: TCnCodeToolStyle; virtual; abstract;
    {* ʽΪ csLineProcessText  Text ûѡ
       ΪСΪ csSelTextText ֻûʵѡı
       Ϊ csAllTextText ȫ Unit ݡ}
    procedure GetNewPos(var ARow: Integer; var ACol: Integer); virtual;
    {* ִϺͨش˺ȷڵλ}
  public
    constructor Create(AOwner: TCnEditorWizard); override;
    procedure Execute; override;
    function GetState: TWizardState; override;
  end;

{$ENDIF CNWIZARDS_CNEDITORWIZARD}

implementation

{$IFDEF CNWIZARDS_CNEDITORWIZARD}

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}

//==============================================================================
// ѡı༭
//==============================================================================

{ TCnEditorCodeTool }

constructor TCnEditorCodeTool.Create(AOwner: TCnEditorWizard);
begin
  inherited;
  ValidInSource := True;
  BlockMustNotEmpty := False;
end;

function TCnEditorCodeTool.ProcessLine(const Str: string): string;
begin
  { do nothing }
end;

function TCnEditorCodeTool.ProcessText(const Text: string): string;
var
  Lines: TStrings;
  i: Integer;
begin
  Lines := TStringList.Create;
  try
    Lines.Text := Text;
    for i := 0 to Lines.Count - 1 do
      Lines[i] := ProcessLine(Lines[i]);
    Result := Lines.Text;
  finally
    Lines.Free;
  end;
end;

procedure TCnEditorCodeTool.Execute;
const
  SCnOtaBatchSize = $7FFF;
var
  View: IOTAEditView;
  Block: IOTAEditBlock;
  Text: AnsiString;
  Buf: PAnsiChar;
  BlockStartLine, BlockEndLine: Integer;
  StartPos, EndPos, ReadStart: Integer;
  Reader: IOTAEditReader;
  Writer: IOTAEditWriter;
  Row, Col, Len, ASize: Integer;
  NewRow, NewCol: Integer;
  Stream: TMemoryStream;
begin
  View := CnOtaGetTopMostEditView;
  if View <> nil then
  begin
    Block := View.Block;
    StartPos := 0;
    EndPos := 0;
    BlockStartLine := 0;
    BlockEndLine := 0;
    NewRow := 0;
    NewCol := 0;
    if GetStyle = csLine then
    begin
      if (Block <> nil) and Block.IsValid then
      begin             // ѡı
        BlockStartLine := Block.StartingRow;
        StartPos := CnOtaEditPosToLinePos(OTAEditPos(1, BlockStartLine), View);
        BlockEndLine := Block.EndingRow;
        // 겻ʱһ
        if Block.EndingColumn > 1 then
        begin
          if BlockEndLine < View.Buffer.GetLinesInBuffer then
          begin
            Inc(BlockEndLine);
            EndPos := CnOtaEditPosToLinePos(OTAEditPos(1, BlockEndLine), View);
          end
          else
            EndPos := CnOtaEditPosToLinePos(OTAEditPos(255, BlockEndLine), View);
        end
        else
          EndPos := CnOtaEditPosToLinePos(OTAEditPos(1, BlockEndLine), View);
      end
      else
      begin    // δѡʾתС
        if CnOtaGetCurSourcePos(Col, Row) then
        begin
          StartPos := CnOtaEditPosToLinePos(OTAEditPos(1, Row), View);
          if Row < View.Buffer.GetLinesInBuffer then
          begin
            EndPos := CnOtaEditPosToLinePos(OTAEditPos(1, Row + 1), View);
            NewRow := Row; 
            NewCol := Col;
            GetNewPos(NewRow, NewCol); // ȷһλñ仯
          end
          else
            EndPos := CnOtaEditPosToLinePos(OTAEditPos(255, Row), View);
        end
        else
        begin
          ErrorDlg(SCnEditorCodeToolNoLine);
          Exit;
        end;
      end;
    end
    else if GetStyle = csSelText then
    begin
      if (Block <> nil) and (Block.IsValid) then
      begin                           // ѡı
        StartPos := CnOtaEditPosToLinePos(OTAEditPos(Block.StartingColumn,
          Block.StartingRow), View);
        EndPos := CnOtaEditPosToLinePos(OTAEditPos(Block.EndingColumn,
          Block.EndingRow), View);
      end;
    end
    else
    begin
      StartPos := 0;
      Stream := TMemoryStream.Create;
      CnOtaSaveCurrentEditorToStream(Stream, False);
      EndPos := Stream.Size - 1; // ñ취õ༭ĳȣ
      // һΪȥ SaveToStream ʱβӵ#0һ
      Stream.Free;
    end;

    Len := EndPos - StartPos;
    Assert(Len >= 0);
    SetLength(Text, Len);
    Buf := Pointer(Text);
    ReadStart := StartPos;

    Reader := View.Buffer.CreateReader;
    try
      while Len > SCnOtaBatchSize do // ζȡ
      begin
        ASize := Reader.GetText(ReadStart, Buf, SCnOtaBatchSize);
        Inc(Buf, ASize);
        Inc(ReadStart, ASize);
        Dec(Len, ASize);
      end;
      if Len > 0 then // ʣ
        Reader.GetText(ReadStart, Buf, Len);
    finally
      Reader := nil;
    end;

    if Text <> '' then
    begin
    {$IFDEF UNICODE_STRING}
      Text := AnsiString(ProcessText(string(ConvertEditorTextToText(Text)))); // ı
    {$ELSE}
      Text := ProcessText(ConvertEditorTextToText(Text)); // ı
    {$ENDIF}
      Writer := View.Buffer.CreateUndoableWriter;
      try
        Writer.CopyTo(StartPos);
        Writer.Insert(PAnsiChar(ConvertTextToEditorText(Text)));
        Writer.DeleteTo(EndPos);
      finally
        Writer := nil;
      end;                      
    end;

    if (NewRow > 0) and (NewCol > 0) then
    begin
      View.CursorPos := OTAEditPos(NewCol, NewRow);
    end
    else if (BlockStartLine > 0) and (BlockEndLine > 0) then
    begin
      CnOtaSelectBlock(View.Buffer, OTACharPos(0, BlockStartLine),
        OTACharPos(0, BlockEndLine));
    end;

    View.Paint;
  end
  else
    ErrorDlg(SCnEditorCodeToolSelIsEmpty);
end;

function TCnEditorCodeTool.GetState: TWizardState;
begin
  Result := inherited GetState;
  if wsEnabled in Result then
  begin
    if ValidInSource and not CurrentIsSource or
      BlockMustNotEmpty and CnOtaCurrBlockEmpty then
      Result := [];
  end;
end;

procedure TCnEditorCodeTool.GetNewPos(var ARow, ACol: Integer);
begin
// ɶıֵ
end;

{$ENDIF CNWIZARDS_CNEDITORWIZARD}
end.
